
#!/bin/bash
#SBATCH --account=your_account
#SBATCH --job-name=60k3bp.ft
#SBATCH --nodes=1
#SBATCH --gpus-per-node=4
#SBATCH --time=03:00:00
#SBATCH --mail-type=END,FAIL

conda init
conda activate fxt
conda env list 
nvidia-smi
export PYTHONPATH=.

cat $0
echo "--------------------"

export PYTHONPATH=$(pwd)
export HF_HOME="cache"
export WANDB_CACHE_DIR="cache"

GPUS=1
config_file=configs/accelerate/gpu_1.yaml


models=(
    # fxt_baseline_1_bp_6_priors_0.1_en_hard_no_binomial/_2025-04-29_22-00-31
    # fxt_baseline_1_bp_6_priors_0.2_en_hard_no_binomial/_2025-04-29_17-06-35
    # fxt_baseline_1_bp_6_priors_0.3_en_hard_no_binomial/_2025-04-29_16-29-47
    # fxt_baseline_1_bp_6_priors_0.3_en_hard_yes_binomial/_2025-04-30_06-11-02
    # fxt_baseline_1_bp_6_priors_0.3_en_hard_no_binomial_lambda_1/_2025-05-04_09-31-46
    # fxt_baseline_1_bp_6_priors_0.3_en_hard_no_binomial_lambda_3/_2025-05-03_14-43-31
    # fxt_baseline_1_bp_6_priors_BPE_50k/_2025-05-10_23-51-40
    fxt_baseline_1_bp_6_priors_BPE/_2025-05-09_20-40-49
)


for model in "${models[@]}"; do
    echo "Starting with model ${model}"
    work_dir="model_ckpts/${model}/"
    echo $work_dir
    echo 'Finding free port'
    PORT=$(python -c 'import socket; s=socket.socket(); s.bind(("", 0)); print(s.getsockname()[1]); s.close()')
    accelerate launch --main_process_port=$PORT --config_file=$config_file --num_processes="$GPUS" src/eval/compression_rate.py  \
      --task "flores" \
      --model_path $work_dir \
      --output_dir "results/compression_rate/" \
      --batch_size 1 
done