#!/bin/bash
#SBATCH --account project_account
#SBATCH --job-name hin40
#SBATCH --nodes=1
#SBATCH --gpus-per-node=1
#SBATCH --ntasks-per-node=2  # Allocate 30 CPU tasks
#SBATCH --cpus-per-task=5     # Each task gets 2 CPUs (60 CPUs total)
#SBATCH --time=20:00:00
#SBATCH --cluster=
#SBATCH --partition=
#SBATCH --mail-type=BEGIN,END,FAIL



source ~/miniforge3/etc/profile.d/conda.sh
conda activate fxt
conda env list 
nvidia-smi

cat $0
echo "--------------------"

export PYTHONPATH=$(pwd)
export HF_HOME=/fs/scratch/project_account/your_username/.cache/
export WANDB_CACHE_DIR=/fs/scratch/project_account/your_username/.cache/

python  src/eval/evaluate_model.py \
    --model_path model_ckpts/fxt_baseline_1_bp_6_priors_0.3_en_hard_no_binomial_lambda_3/_2025-05-03_14-43-31 \
    --output_dir model_ckpts/results \
    --eval_batch_size 64

