"""
Original code from: parlai.agents.rag.retrievers
"""


from typing import Union


class Document:
    """
    A Document used in retrieval.
    """

    TITLE_DELIM = ' / '
    PASSAGE_DELIM = ' // '

    def __init__(self, title: str, text: str, docid: Union[int, str]):
        assert all(isinstance(t, str) for t in [title, text])
        self._title = title
        self._text = text
        self._id = str(docid)

    def get_title(self) -> str:
        return self._title

    def get_text(self) -> str:
        return self._text

    def get_id(self) -> str:
        return self._id

    def __repr__(self):
        return f"ID: {self._id}\nTitle: {self._title}\nText: {self._text}"

    def __str__(self):
        return f"{self._title} | {self._text}"

    def get_passage_str(self):
        return f"{self._title.strip()}{self.TITLE_DELIM}{self._text.strip()}{self.PASSAGE_DELIM}"

    def get_tokenization_str(self):
        return f"{self._title.strip()}{self.TITLE_DELIM}{self._text.strip()}"

    def asdict(self):
        return {
            "title": self._title.split('_')[0],
            "text": self._text
        }