import re

def parse_gamefile(env):
    pddl_env = env.batch_env.envs[0]
    if hasattr(pddl_env, 'gamefile'):
        gamefile = pddl_env.gamefile
    else:
        gamefile = pddl_env._game_file

    marker = "json_2.1.1/"
    index = gamefile.find(marker)
    if index != -1:
        return gamefile[index + len(marker):]
    else:
        return None

def extract_task_from_observation(observation):
    match = re.search(r"(?<=\n\nYour task is to: ).*", observation)
    task = match.group() if match else ""
    return task