#ifndef ButtonBar_H
#define ButtonBar_H

#include "BaseWnd.h"
#include "Bitmap.h"

/**
 * @ingroup Controls
 The ButtonBar control implements a toolbar containing buttons. Each button
 contains an image file. When a button is clicked, a WM_COMMAND notification
 will be sent to the parent window, or to the command target given using
 setCommandTarget().
 
 Only a horizontal layout is implemented.
 */
class ButtonBar : public Window
{
public:
    ButtonBar(HINSTANCE);
    ~ButtonBar();

    void create(HWND hwnd, bool reduce_size = false);
    void setCommandTarget( HWND hTarget );
    void addButton( unsigned id, unsigned bmp_out_id, unsigned bmp_over_id,
            unsigned bmp_down_id, unsigned bmp_disabled_id );
    void addButton( unsigned id, const _TCHAR* bmp_out_id, 
        const _TCHAR* bmp_over_id, const _TCHAR* bmp_down_id, 
        const _TCHAR* bmp_disabled_id );
    void addButton( HWND hwnd );
    void enable( unsigned id, bool enabled );
    bool isHorizontal();

    void setBackColour( DWORD colour );
    void setBackImage( const _TCHAR* bmp_id, bool rightAlign );

private:
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void onClose(HWND);
    void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct);
    void onDestroy(HWND hwnd);
    void onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onPaint( HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient );
    void onPaint(HWND hwnd, WPARAM wParam, LPARAM lParam);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
    bool _reduceSize;
    void scale( BitmapRef bmp );

    class Button;
    Button* find( unsigned id );

    int _padding; // margins
    int _spacing; // between bmps
    Button** _buttons;
    int _numButtons;
    void layout();
    HWND _cmdTarget;
    DWORD _backColour;
    Bitmap* _backImage;
    bool _backImageRightAlign;
};

#endif // ButtonBar_H
