#ifndef BUTTON_CONTROL_H
#define BUTTON_CONTROL_H

#include "Control.h"
#include "TextControl.h"
#include "BaseWnd.h"

class Bitmap;

/** 
 * @ingroup SlidingControls
 The ButtonControl class will show a rectangle containing a bullet or bitmap,
 and some word-wrapped text. When it is clicked, a WM_COMMAND message will
 be sent to the parent window. When the mouse is over it, the colour will fade
 to the fade colour, and when the mouse leaves, the colour will 
 gradually change to the button's colour.
 */
class ButtonControl : public FadingControl
{
public:
    ButtonControl(HWND, DWORD commandId = 0);
    virtual ~ButtonControl();

    virtual void onMouseEnter();
    virtual void onMouseOut();
    virtual void draw( HDC dc );
    virtual void move( int x, int y, int cx, int cy );
    virtual void setFadeTime( unsigned TimeMs );
    virtual void onLButtonDown( int x, int y, UINT keyFlags );

    void setText( const TCHAR* text );
    void setBitmap( Bitmap* bitmap );
    void setBackColour( COLORREF );
    void setRounding( int width );
    void setBulletSquare( COLORREF colour );
    void setFont( const Font& font );
    TextControl* getText();
    int moveFormat( int x, int y, int width );
    SIZE calcSize();
    DWORD commandId;

private:
    void format();
    int _insideMargin;
    Bitmap* _bitmap;
    TextControl _textControl;
    POINT _picturePos;
    COLORREF _backColour;
    int _roundEllipse;
    
    int _bulletHeight;
    COLORREF _bulletColour;
    bool _useBullet;
};

#endif // BUTTON_CONTROL_H
