#ifndef ButtonWindow_H
#define ButtonWindow_H

#include "BaseWnd.h"
#include "Bitmap.h"

/**
 * @defgroup Controls
 *
 * Controls are subclasses of of the Window object, designed for user
 * interaction.
 */ 

/**
 * @ingroup Controls
 The ButtonWindow class represents a button which displays an image. It may
 have an image when disabled, when the mouse is outside, when the mouse is over
 the button, and when the mouse button is depressed.
 */
class ButtonWindow : public Window
{
public:
    ButtonWindow(HINSTANCE);
    ~ButtonWindow();

    void create(HWND hParent, unsigned id);

    enum BitmapType_e {
        Disabled,
        Out,
        Over,
        Down,

        NUM_BITMAPS
    };

    void setBitmap( BitmapType_e type, BitmapRef bmp );
    void setEnabled( bool enabled );

private:
    void setSize();
    
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void onClose(HWND);
    void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct);
    void onDestroy(HWND hwnd);
    void onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onPaint(HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
    void onMouseLeave(HWND);
    BitmapType_e _state;
    BitmapRef _bmps[NUM_BITMAPS];
    unsigned _id;
    bool _down;
};

#endif // ButtonWindow_H
