#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "CgiRequest.h"

/**
 Construct a CGI request. When constructed, the QUERY_STRING environment
 variable is parsed.
 */
CgiRequest::CgiRequest()
{
    // set number of items to 0
    _numItems = 0;
    
    // get the QUERY_STRING
    const char* QUERY_STRING = getenv("QUERY_STRING");

    if ( QUERY_STRING == 0 ) {
        return;
    }

    printf("QUERY_STRING=%s\n", QUERY_STRING);
    
    // count number of '='
    char* str = strdup( QUERY_STRING );
    char* pos = str;
    while( *pos ) {
        if ( *pos == '=' ) {
            _numItems++;
        }
        pos++;
    }

    // reserve space.
    _items = (Item*)malloc(_numItems * sizeof(Item));

    // tokenize on &
    const char* key = strtok( str, "&" );
    unsigned got = 0;
    
    // for each item,
    while(key && got < _numItems) {

        // find first '='
        const char* value = strtok( NULL, "=" );
        if ( value == 0 ) {
            value = "";
        }

        // unescape key
        _items[got].key = strdup( key );
        unescape( _items[got].key, key );

        // unescape value
        _items[got].value = strdup( value );
        unescape( _items[got].value, value );

        printf("%s=%s\n", _items[got].key, _items[got].value);
        
        key = strtok( NULL, "&" );

        got++;
    }
        
    free( str );
}

CgiRequest::~CgiRequest()
{
    for ( unsigned i = 0; i < _numItems; i++ ) {
        free( _items[i].key );
        free( _items[i].value );
    }

    free( _items );
}

/**
 Returns the value of the key passed in the QUERY_STRING environment
 variable. The HTML special characters, eg. "+" and "%32" have been already
 converted.
 */
const char*
CgiRequest::get(const char* key)
{
    for ( unsigned i = 0; i < _numItems; i++ ) {
        if ( strcmp( key, _items[i].key ) == 0 ) {
            return _items[i].value;
        }
    }

    return 0;
}

char CgiRequest::fromHex( const char* str )
{
    char result = 0;
    for ( unsigned i = 0; i < 2; i++ ) {
        if ( str[i] >= '0' && str[i] <= '9' ) {
            result += str[i] - '0';
        } else if ( str[i] >= 'A' && str[i] <= 'F' ) {
            result += 10 + str[i] - 'A';
        }
        result <<= 4;
    }

    return result;
}

void CgiRequest::unescape( char* dest, const char* src )
{
    // for each character,
    while( *src ) {
        // if it's '%',
        if ( src[0] == '%' && src[1] != 0 && src[2] != 0 ) {
            // get next two characters. 
            
            // convert next two characters into char and add to string
            *dest++ = fromHex( &src[1] );
            src += 3;
        } else {
            // otherwise, just add to string.
            *dest++ = *src;
            src += 1;
        }
    }
}
