#ifndef CONTROL_H
#define CONTROL_H

#include <windows.h>
#include "Fill.h"
#include "List.h"

extern unsigned _twipsX;
extern unsigned _twipsY;
int TwipsToPixelsX( int twips );
int TwipsToPixelsY(int twips);

class Control;

class ControlHandler
{
public:
    ControlHandler();
    virtual ~ControlHandler();

protected:
    friend class Control;

    virtual void eventMouseEnter( Control* );
    virtual void eventMouseOut( Control* );
    virtual void eventMouseClick( Control* );
};

/**
 * @defgroup SlidingControls
 *
 * A Control is a base class for Steve's sliding control library. It allows you to
 * define separate controls will which slide onto the screen. Each control does
 * not use a separate window -- instead, they are all drawn onto a parent
 * window that you specify.
 */

/**
 * @ingroup SlidingControls
 *
 * A Control is a base class for Steve's sliding control library. It allows you to
 * define separate controls will which slide onto the screen. Each control does
 * not use a separate window -- instead, they are all drawn onto a parent
 * window that you specify.
 */
class Control
{
public:
    Control(HWND hwnd);
    virtual ~Control();

    virtual void addChild( Control* child );
    virtual void move( int x, int y, int cx, int cy );
    virtual void onMouseMove( int x, int y, UINT keyFlags );
    virtual void onMouseEnter();
    virtual void onMouseOut();
    virtual void onLButtonDown( int x, int y, UINT keyFlags );
    virtual void draw( HDC dc );
    virtual void onMessage( unsigned msg, WPARAM, LPARAM );
    void setHandler( ControlHandler* );
    virtual void invalidate();
    void setBackgroundFill( const Fill& fill );
    void offset( int* x, int* y);
    void offset( RECT* rect );
    void offset( POINT* pt );
    void unoffset( int* x, int* y);
    RECT getWindowRect();
    RECT _rect;

protected:
    HWND _hwnd;
    bool hover();
    ControlHandler* _handler;
    static const unsigned DefaultFadeMs;
    Control* _parent;
    List<Control*> _children;

private:
    Fill _fill;
    bool _mouseHover;
};


#endif // CONTROL_H
