#ifndef CONTROLPAGE_H
#define CONTROLPAGE_H

#include "Control.h"
#include "List.h"

class ControlTimer;
class ControlPos;

/**
 * @ingroup SlidingControls
 * A ControlPage is part of the sliding window library, and it allows
 * a group of controls to slide on and off the screen.
 *
 * Controls may be added to the page. Each control will have an offscreen
 * position, and an on-screen position.  All positions are relative to the
 * control page.
 */
class ControlPage : public Control
{
public:
    ControlPage( HWND hwnd );
    ~ControlPage();

    void animate( Control*, RECT* end, int x, int y, bool on = true );
    void animateStop();
    virtual void drawAnimated(ControlPos*, double percent);
    virtual void animate(bool on);

protected:
    void addChild( Control*, int x, int y, int cx, int cy, int
            offsetX, int offsetY, bool moveNow = false );
    void addChild( Control* control, int x, int y, int cx, int cy );
    void animateAll(bool on);
    virtual void animateDone( bool show );
    bool animating();

private:
    ControlPos* find( Control* control );
    friend class ControlTimer;
    bool _animating;
    bool _visible;
    ControlTimer* _controlTimer;
    unsigned _animateTimeMs;
    void onTimer();
    List<ControlPos*> _controlPos;
    List<ControlPos*> _controlsAll;
};

#endif // CONTROLPAGE_H
