#pragma warning(disable:4786)
#include <windows.h>
#include <assert.h>
#include "DrawTimer.h"	
#include "List.h"

static List<TimerEvent*> _events;
static bool _active = false;
unsigned _id = 0;

VOID CALLBACK DrawTimer::TimerManagerProc(HWND hwnd, UINT uMsg, UINT idEvent, 
        DWORD dwTime)
{
    assert( _active );

    TimerEvent* event = _events.first();
    while( event ) {
        event->fire( _id );
        event = _events.next();
    }
}

unsigned 
DrawTimer::RegisterEvent(TimerEvent* event)
{
    TimerEvent* cevent = _events.first();
    while( cevent ) {
        if ( cevent == event ) {
           assert(0);
          return 0;
        }
       cevent = _events.next();
    }

    _events.addTail( event );

    if ( !_active ) {
        _id = SetTimer(NULL, NULL, 10, TimerManagerProc);
        _active = true;
    }

    return _id;
}

void DrawTimer::CancelEvent(TimerEvent* event)
{
    TimerEvent* cevent = _events.first();
    while( cevent ) {
        if ( cevent == event ) {
            _events.remove();
            break;
        }
       cevent = _events.next();
    }

    if ( cevent == 0 ) {
        return;
    }

    assert( _active );

    if ( _events.empty() ) {
        _active = false;
        KillTimer( NULL, _id );
    }
}
