#ifndef FADINGCONTROL_H
#define FADINGCONTROL_H

#include "Control.h"

class FadeTimer;

class FadingControl : public Control
{
public:
    FadingControl(HWND hwnd);
    ~FadingControl();

    void allowFading(bool allow);
    virtual void setFadeTime( unsigned TimeMs );
    virtual void drawFaded( HDC dc );
    virtual void onMouseEnter();
    virtual void onMouseOut();
    void setFadedColour( COLORREF );

protected:
    COLORREF getFadeColour( COLORREF UnFaded );
    double intensity();
    bool _allowFading;

private:
    friend class FadeTimer;
    enum FadeState_e {
        Fading_In,
        Fading_Out,
        Not_Fading
    } _fadeState;
        
    void onTimer();
    unsigned _fadeTimeMs;
    FadeTimer* _fadeTimer;
    unsigned _timeStarted;
    double _intensity;
    COLORREF _fadedColour;
};

#endif // FADINGCONTROL_H
