#include "Fill.h"
#include "win95.h"

Fill::Fill()
{
    _type = Fill_NONE;
    _size.cx = _size.cy = 1;
}

Fill::~Fill()
{

}

Fill::Fill( const Fill& right )
{
    *this = right;
}

Fill& Fill::operator=( const Fill& right )
{
    _size = right._size;
    _type = right._type;
    _start = right._start;
    _end = right._end;
    return *this;
}

void
Fill::setSize( int x, int y )
{
    _size.cx = x;
    _size.cy = y;
}

static void MakeVertex( TRIVERTEX* tri, LONG x, LONG y, COLORREF c )
{
    tri->x = x;
    tri->y = y;
    tri->Red = (COLOR16)((double)GetRValue(c)/255*0xff00);
    tri->Green = (COLOR16)((double)GetGValue(c)/255*0xff00);
    tri->Blue = (COLOR16)((double)GetBValue(c)/255*0xff00);
    tri->Alpha = 0;
}

static void MakeTriangle( GRADIENT_TRIANGLE* tri, ULONG t1, ULONG t2, ULONG t3 )
{
    tri->Vertex1 = t1;
    tri->Vertex2 = t2;
    tri->Vertex3 = t3;
}

void
Fill::setGradientTopBottom( COLORREF top, COLORREF bottom )
{
    _type = Fill_VERTICAL;
    _start = top;
    _end = bottom;
}

void
Fill::setGradientLeftRight( COLORREF right, COLORREF left )
{
    _type = Fill_HORIZONTAL;
    _start = right;
    _end = left;
}

void
Fill::setSolid( COLORREF colour )
{
    _type = Fill_SOLID;
    _start = colour;
}

void
Fill::draw( HDC dc, int x, int y )
{

    if ( _type == Fill_NONE ) {
        return;
    }

    if ( _type == Fill_VERTICAL || _type == Fill_HORIZONTAL ) {
        TRIVERTEX vert[2];
        MakeVertex( &vert[0], x, y, _start );
        MakeVertex( &vert[1], x + _size.cx, y + _size.cy, _end );
        GRADIENT_RECT rect[1];
        rect[0].UpperLeft = 0;
        rect[0].LowerRight = 1;

        if ( _type == Fill_VERTICAL ) {
            SafeGradientFill( dc, vert, 2, rect, 1, GRADIENT_FILL_RECT_V );
        } else { 
            SafeGradientFill( dc, vert, 2, rect, 1, GRADIENT_FILL_RECT_H );
        }
    } else if ( _type == Fill_SOLID ) {
        HBRUSH brush = CreateSolidBrush( _start );
        RECT rect;
        rect.left = x;
        rect.top = y;
        rect.right = x + _size.cx + 1;
        rect.bottom = y + _size.cy + 1;
        FillRect( dc, &rect, brush );
        DeleteObject( brush );
    }
}
