#ifndef FILL_H
#define FILL_H

#include <windows.h>

/**
 * @defgroup Graphics
 *
 * The graphics objects have to do with images, and drawing to the screen.
 */ 

/**
 * @ingroup Graphics
 *
 * Describes a Fill. A fill may be solid, or a vertical or horizonal gradient.
 * Use the draw() function to draw the fill onto a device context. Note that
 * horizontal and gradient fills also require a size.
 */
class Fill
{
public:
    Fill();
    Fill( const Fill& right );
    Fill& operator=(const Fill& right );
    ~Fill();
    

    void setGradientTopBottom( COLORREF top, COLORREF bottom );
    void setGradientLeftRight( COLORREF right, COLORREF left );
    void setSize( int x, int y );
    void setSolid( COLORREF color);

    void draw( HDC dc, int x, int y );

protected:
    SIZE _size;
    enum Type {
        Fill_NONE,
        Fill_VERTICAL,
        Fill_HORIZONTAL,
        Fill_SOLID
    } _type;


    // for Gradient_VERTICAL
    COLORREF _start;
    COLORREF _end;
};


#endif // FILL_H

