#ifndef ImageWindow_H
#define ImageWindow_H

#include "ScrollWindow.h"
#include "NavWindow.h"
#include "DibImage.h"

/**
 * @ingroup Controls
 * The ImageWindow class is a control for displaying an image. The image can be
 * resized, or if it is larger than the window, it is possible to scroll
 * around. The user may scroll using scrollbars, or by dragging the image.
 *
 * The ImageWindow will optionally display a thumbnail of the whole image in a
 * child control, that the user can use to navigate around an exceptionally
 * large image.
 */
class ImageWindow : public ScrollWindow
{
public:
    ImageWindow(HINSTANCE);
    ~ImageWindow();

    virtual void create(HWND hParent, int x, int y, int cx, int cy);
    void setImage(DibImageRef image);
    void setImage(Bitmap* bmp);
    double getScale();
    int getOffsetX();
    int getOffsetY();
    void zoomFullPage();
    virtual void setZoom(double zoom);
    void getViewRect(RECT* src, RECT* viewPort);
protected:
    virtual void onScroll(int x, int y );

	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void onClose(HWND);
    void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct);
    void onDestroy(HWND hwnd);
    void onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
    UINT onNcCalcSize(HWND hwnd, BOOL fCalcValidRects, NCCALCSIZE_PARAMS * lpcsp);
    void onPaint( HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient );
private:
    HBRUSH _hatchBrush;
    DibImageRef _image;
    double _zoom;
    NavWindow _navWindow;
    bool _firstSize;
    bool _zoomFullPage;
};

#endif // ImageWindow_H
