#ifndef LOGFILE_H
#define LOGFILE_H

#include "List.h"

/**
 * The LogFile class is used for debugging and user logs. It maintains a list
 * of the last 1000 lines added. Its destructor will save the lines to the
 * file. 
 */
class LogFile
{
public:
	LogFile(const char* destination, int backtrace = 1000);
	LogFile();
	~LogFile();

	void nextline();

	void setLength(int lines);
	void setDestination(const char* file);
	void enable();
	void disable();
    void printf(const char* fmt, ... );
    void addLine( const char* );

	void flush();
protected:
	void construct();
	List<char*> _strings;
	char* _destination;
	int _backtrace;
	bool _enabled;
    int _size;
};

#endif //LOGFILE_H
