#ifndef STEVE_MAP_H
#define STEVE_MAP_H

class MapBase
{
public:
    MapBase();
    MapBase( unsigned numEntries );
    ~MapBase();

    bool add( void* key, void* value );
    bool lookup( void* key, void** value );

    void* first();
    void* next();
    void clear();

protected:
    bool allowDuplicates;

private:
    void construct( unsigned numEntries );
    void destruct();
    unsigned nextPrimeNumber( unsigned num );
    unsigned hash( void* key );
    int entries_alloc;
    struct Entry_t {
        void* key;
        void* value;
        struct Entry_t* next;
    }** entries;

    int index;
    Entry_t* pos;
};

/**
 * Implements a hash table from keys to values. The key must be a four byte
 * integer or a pointer. The values must be pointers.
 */
template< class KEY_PTR, class VALUE_PTR >
class Map : protected MapBase
{
public:
    Map() 
    {
    }

    /**
     * Construct a hash table.
     * @param Size The expected number of entries in the hash table. This
     * should be as large as possible, and a prime number.
     */
    Map( unsigned Size ) : MapBase(Size)
    {
    }

    bool add( KEY_PTR key, VALUE_PTR value ) {
        return MapBase::add( key, static_cast<void*>(value) );
    }

    bool lookup( KEY_PTR key, VALUE_PTR* value ) {
        return MapBase::lookup( key, reinterpret_cast<void**>(value) );
    }


    VALUE_PTR first() {
        return static_cast<VALUE_PTR>(MapBase::first());
    }

    const VALUE_PTR next() const {
        Map<KEY_PTR, VALUE_PTR>* ptr = const_cast<Map<KEY_PTR, VALUE_PTR>*>(this);
        return (static_cast<const VALUE_PTR>(ptr->MapBase::next()));
    }

    void clear() {
        MapBase::clear();
    }
};

#endif // STEVE_MAP_H
