#include "MemoryMappedFile.h"
#include "dbg.h" // must be last.

MemoryMappedFile::MemoryMappedFile()
{
    _ptr = 0;
    _hMapFile = NULL;
    _hFile = NULL;
}

MemoryMappedFile::~MemoryMappedFile()
{
    close();
}

bool 
MemoryMappedFile::open( HANDLE hFile, unsigned __int64 size )
{
    HANDLE hMapFile = CreateFileMapping(
                 hFile, 
                 NULL,                    // default security 
                 PAGE_READWRITE,          // read/write access
                 0,                       // max. object size 
                 (DWORD)size,                    // buffer size  
                 NULL);                   // name of mapping object
 
	int a = GetLastError();
    if ( hMapFile == NULL ) { 
        return false;
    }

    void* ptr = MapViewOfFile(hMapFile,   // handle to map object
                        FILE_MAP_ALL_ACCESS, // read/write permission
                        0,                   
                        0,                   
                        (DWORD)size);           
 
	a = GetLastError();
    if (ptr == NULL) { 
       CloseHandle( hMapFile );
       return false;
    }

    _ptr = ptr;
    _hFile = hFile;
    _hMapFile = hMapFile;
    _size = size;

    return true;
}

bool 
MemoryMappedFile::open( const _TCHAR* name )
{
    close();

    // open file with CreateFile
    HANDLE hFile = CreateFile( name, 
            GENERIC_READ | GENERIC_WRITE, 
            FILE_SHARE_READ, 
            NULL,
            OPEN_EXISTING, 
            0,
            NULL
            );

    if ( hFile == INVALID_HANDLE_VALUE ) {
        return false;
    }

    LARGE_INTEGER lsize;
    // find and open the file. Handle failure.
    // Find the size of the file.
    lsize.LowPart = lsize.HighPart = 0;
    GetFileSizeEx( hFile, &lsize );
    unsigned __int64 size = lsize.QuadPart;
    
    if ( !open( hFile, size )  ) {
        CloseHandle( hFile );
        return false;
    }

    return true;

}

bool 
MemoryMappedFile::create( const _TCHAR* name, unsigned __int64 size )
{
    HANDLE hFile = CreateFile( name, 
            GENERIC_READ | GENERIC_WRITE, 
            FILE_SHARE_READ, 
            NULL,
            CREATE_ALWAYS, 
            0,
            NULL
            );

    if ( hFile == INVALID_HANDLE_VALUE ) {
        return false;
    }
    
    if ( !open( hFile, size )  ) {
        CloseHandle( hFile );
        return false;
    }

    return true;
}

void 
MemoryMappedFile::close()
{
    if ( _ptr ) {
        UnmapViewOfFile( _ptr );
        CloseHandle( _hMapFile );
        CloseHandle( _hFile );
    }

    _ptr = 0;
    _hMapFile = NULL;
    _hFile = NULL;

}
        

void* 
MemoryMappedFile::ptr()
{
    return _ptr;

}

unsigned __int64 
MemoryMappedFile::size()
{
    return _size;
}

