#ifndef MemoryMappedFile_H
#define MemoryMappedFile_H

#include <windows.h>
#include <tchar.h>

class MemoryMappedFile
{
public:
	MemoryMappedFile();
	~MemoryMappedFile();

    bool open( const _TCHAR* name );
    bool create( const _TCHAR* name, unsigned __int64 size );
    void close();
    void* ptr();
    unsigned __int64 size();

private:	
    bool open( HANDLE hFile, unsigned __int64 size );

    HANDLE _hFile;
    HANDLE _hMapFile;
    void* _ptr;
    unsigned __int64 _size;
};

#endif // MemoryMappedFile_H
