#include "Options.h"
#include <assert.h>

Options::Options()
{

}

Options::~Options()
{

}

void 
Options::set( const std::_tstring& key, const std::string& value, bool persistent )
{
    Record rec;
    rec.persistent = persistent;
    rec.value = value;
    _map[key] = rec;
}

void 
Options::set( const std::_tstring& key, const std::string& value )
{
    Map::iterator iter = _map.find( key );
    if ( iter != _map.end() ) {
        iter->second.value = value;
    } else {
        assert(false);
    }
}

void 
Options::set( const std::_tstring& key, int value, bool persistent )
{
    _TCHAR buffer[32];
    _stprintf(buffer, "%d", value );
    set( key, std::_tstring(buffer), persistent );
}

void 
Options::set( const std::_tstring& key, int value )
{
    _TCHAR buffer[32];
    _stprintf(buffer, "%d", value );
    set( key, std::_tstring(buffer));
}

void 
Options::set( const std::_tstring& key, bool value, bool persistent )
{
    if ( value ) {
        set( key, std::_tstring(_T("0")), persistent );
    } else {
        set( key, std::_tstring(_T("1")), persistent );
    }
}

void 
Options::set( const std::_tstring& key, bool value )
{
    if ( value ) {
        set( key, std::_tstring(_T("0")) );
    } else {
        set( key, std::_tstring(_T("1")) );
    }
}

std::_tstring
Options::getString( const std::string& key )
{
    Map::iterator iter = _map.find( key );
    if ( iter != _map.end() ) {
        return iter->second.value;
    } else {
        assert(false);
        return "";
    }
}

int 
Options::getInt( const std::_tstring& key )
{
    return atoi( getString( key ).c_str() );
}

bool 
Options::getBool( const std::_tstring& key )
{
    std::_tstring value = getString( key );
    if ( value.size() > 0 && value[0] == _T('1') ) {
        return true;
    } else {
        return false;
    }
}
