#ifndef Options_H
#define Options_H

#include <map>
#include <tstring>

class Options
{
public:
	Options();
	~Options();

    void set( const std::_tstring& key, const std::string& value, bool persistent );
    void set( const std::_tstring& key, const std::string& value );
    void set( const std::_tstring& key, int value, bool persistent );
    void set( const std::_tstring& key, int value );
    void set( const std::_tstring& key, bool value, bool persistent );
    void set( const std::_tstring& key, bool value );

    int getInt( const std::_tstring& key );
    bool getBool( const std::_tstring& key );
    std::_tstring getString( const std::string& key );

private:
    struct Record {
        bool persistent;
        std::string value;
    };
    typedef std::map<std::_tstring, Record> Map;

    Map _map;
};

extern Options* _options;

#endif // Options_H
