// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#include "OverlappedFile.h"

OverlappedFile::OverlappedFile()
{
	_hFile = 0;
}

OverlappedFile::~OverlappedFile()
{
    if ( _hFile ) {
        CloseHandle( _hFile );
    }

}

bool 
OverlappedFile::create( const _TCHAR* filename, unsigned flags )
{
    return open( filename, true, flags );
}

bool 
OverlappedFile::open( const _TCHAR* filename, unsigned flags )
{
    return open( filename, false, flags );
}

OverlappedFile::operator HANDLE()
{
    return _hFile;
}

bool 
OverlappedFile::open( const _TCHAR* filename, bool create, unsigned flags )
{
    flags |= FILE_FLAG_OVERLAPPED;
    DWORD disposition = create ? OPEN_ALWAYS : OPEN_EXISTING;
    // open file with CreateFile
    HANDLE hFile = CreateFile( filename, 
            GENERIC_READ | GENERIC_WRITE, 
            FILE_SHARE_READ, 
            NULL,
            disposition, 
            flags,
            NULL
            );

	int a = GetLastError();
    if ( hFile == INVALID_HANDLE_VALUE ) {
        return false;
    }

    _hFile = hFile;
    return true;
}

OverlappedOperation::OverlappedOperation( HANDLE hFile ) :
    _hFile(hFile),
    _started(false)
{
    memset( &_ol, 0, sizeof(_ol) );
    _ol.hEvent = CreateEvent( NULL, TRUE, TRUE, NULL );
}

OverlappedOperation::~OverlappedOperation()
{
    cancel();
    wait();
    CloseHandle( _ol.hEvent );
}

bool 
OverlappedOperation::read( unsigned __int64 offset, unsigned length, void* buffer )
{
    _ol.OffsetHigh = (DWORD)(offset >> 32);
    _ol.Offset = (DWORD)offset;

    ResetEvent( _ol.hEvent );
    BOOL result = ReadFile( _hFile, buffer, length, NULL, &_ol );
    int a = GetLastError();
    return result == TRUE || a == ERROR_IO_PENDING;
}

void
OverlappedOperation::cancel()
{
    if ( _started ) {
        // Makes us only run on Windows XP and above.
        // Only works on the calling thread.
        // CancelIoEx, which is what we really need, only works on Vista.
        //CancelIo( _hFile );
    }
}

bool 
OverlappedOperation::write( unsigned __int64 offset, unsigned length, void* buffer )
{
    _ol.OffsetHigh = (DWORD)(offset >> 32);
    _ol.Offset = (DWORD)offset;

    ResetEvent( _ol.hEvent );
    BOOL result = WriteFile( _hFile, buffer, length, NULL, &_ol );
    int a = GetLastError();
    return result == TRUE || a == ERROR_IO_PENDING;
}

bool 
OverlappedOperation::done()
{
    DWORD dwTransferred = 0;
    BOOL result = GetOverlappedResult( _hFile, &_ol, &dwTransferred, FALSE );
    return result == TRUE || result == FALSE && GetLastError() != ERROR_IO_INCOMPLETE;
}

bool 
OverlappedOperation::wait()
{
    if ( !_started ) {
        return false;
    }
    DWORD dwTransferred = 0;
    BOOL result = GetOverlappedResult( _hFile, &_ol, &dwTransferred, TRUE );
    return result == TRUE;
}

