// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef OverlappedFile_H
#define OverlappedFile_H

#include <windows.h>
#include <tchar.h>

/**
  Represents an overlapped read or write operation on a file.

  \warning Do not use this class for more than one operation at a time. You
  must wait for one operation to complete before starting the next one.
  */
class OverlappedOperation
{
public:
    OverlappedOperation( HANDLE hFile );
    virtual ~OverlappedOperation();

    bool read( unsigned __int64 offset, unsigned length, void* buffer );
    bool write( unsigned __int64 offset, unsigned length, void* buffer );
    bool done();
    void cancel();
    bool wait();

protected:
    bool _started;
    OVERLAPPED _ol;
    HANDLE _hFile;
};

/**
  * Makes it easy to open a file in Overlapped mode, so you can perform
  * Asynchronous reads and writes to it using the OverlappedOperation class.
  */
class OverlappedFile
{
public:
	OverlappedFile();
	~OverlappedFile();

    // Flags: FILE_FLAG_NO_BUFFERING, FILE_FLAG_DELETE_ON_CLOSE

    bool create( const _TCHAR* filename, unsigned flags = 0 );
    bool open( const _TCHAR* filename, unsigned flags = 0 );
    operator HANDLE();

private:	
    bool open( const _TCHAR* filename, bool create, unsigned flags );
    HANDLE _hFile;
};

#endif // OverlappedFile_H
