#include "SplitterWindow.h"
#include <assert.h>
#include <windowsx.h>


SplitterWindow::SplitterWindow(HINSTANCE hInstance)
{
	_hInstance = hInstance;
	_pszClassName = _T("SplitterWindow");
	_pszTitle = _T("insert title here");

    _dwStyle |= WS_CLIPCHILDREN | WS_VISIBLE | WS_CHILD;  
 
    _WndClass.hbrBackground = (HBRUSH)NULL_BRUSH;
    _WndClass.hCursor = NULL;
	_WndClass.style |= CS_HREDRAW | CS_VREDRAW;
    _dwExtendedStyle |= 0;
    _numPanes = 0;
    
    _horizontal = true;
    _immobile = false;
    _pos = 320;
    _gravity = 0.5;
    _thickness = 15;
    _over = false;
    _dragging = false;
    _first = true;
    _originalSize.x = _originalSize.y = 0;
    _size.x = _size.y = 0;
    _paneSize[0] = _paneSize[1] = 0;
}

SplitterWindow::~SplitterWindow()
{
}

void
SplitterWindow::create( HWND hParent )
{
    Window::Create(CW_USEDEFAULT, CW_USEDEFAULT,
            CW_USEDEFAULT, CW_USEDEFAULT, hParent, 0, _hInstance );
    assert(hwnd);
}

void 
SplitterWindow::split( HWND pane1, HWND pane2, bool vertical )
{
    _horizontal = !vertical;
    _numPanes = 0;

    if ( pane1 ) {
        _panes[_numPanes++] = pane1;
    }

    if ( pane2 ) {
        _panes[_numPanes++] = pane2;
    }
}

void
SplitterWindow::setPaneSizes( int pane1, int pane2, double gravity )
{
    _paneSize[0] = pane1;
    _paneSize[1] = pane2;
    _gravity = gravity;
    format();
}

void 
SplitterWindow::setSashPosition( int pos, double gravity )
{
    setPaneSizes( pos, pos, gravity );
}

void
SplitterWindow::swap( RECT* rect )
{
    if ( _horizontal ) {
        int temp;
        temp = rect->left;
        rect->left = rect->top;
        rect->top = temp;
        temp = rect->right;
        rect->right = rect->bottom;
        rect->bottom = temp;
    }
}

void
SplitterWindow::swap( POINT* point )
{
    if ( _horizontal ) {
        int temp;
        temp = point->x;
        point->x = point->y;
        point->y = temp;
    }
}

RECT 
SplitterWindow::barRect()
{
    RECT brect = getClientRect();
    swap( &brect );
    brect.left = brect.left + _pos - _thickness / 2;
    brect.right = brect.left + _thickness;
    swap( &brect );
    return brect;
}

void
SplitterWindow::format()
{
    RECT rect = getClientRect();
    RECT orect = rect;
    int idealSize = _paneSize[0] + _paneSize[1];
    swap( &rect );
    int available = rect.right;
    int diff = available-idealSize;
    int oldPos = _pos;
    _pos = _paneSize[0] + (int)((1.0-_gravity)*diff);
    printf("_paneSizes=%d,%d idealSize=%d available=%d diff=%d _pos=%d\n",
        _paneSize[0], _paneSize[1], idealSize, available, diff, _pos );
    if ( _pos < 0 ) {
        _pos = 0;
    }

    if ( oldPos != _pos || ( _size.x != orect.right || _size.y != orect.bottom ) ) {
        _size.x = orect.right;
        _size.y = orect.bottom;
        move();
    }
}

LRESULT 
SplitterWindow::WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed)
{
    *pbProcessed = TRUE;

    switch(msg)
    {
        HANDLE_MSG(hwnd, WM_LBUTTONDOWN, onLButtonDown);
        HANDLE_MSG(hwnd, WM_LBUTTONUP, onLButtonUp);
        HANDLE_MSG(hwnd, WM_MOUSEMOVE, onMouseMove);
        HANDLE_MSG(hwnd, WM_SIZE, onSize);
        case WM_ERASEBKGND:
            return 1;
        case WM_PRINTCLIENT:
            onPaint(hwnd, wParam, lParam, true);  
            return 0;
        case WM_PAINT:
            onPaint(hwnd, wParam, lParam, false);
            return 0;
    }
    
    *pbProcessed = FALSE;
    return 0;
}

void 
SplitterWindow::onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, 
                               UINT keyFlags)
{
    if ( _over ) {
        onMouseMove( hwnd, x, y, keyFlags );
        _dragStart.x = x;
        _dragStart.y = y;
        _dragging = true;
        _posStart = _pos;
        SetCapture(hwnd);
    }
}

void 
SplitterWindow::onPaint( HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient )
{
	PAINTSTRUCT PaintStruct;
    HDC hdc;

    if ( !printClient ) {
	    BeginPaint(hwnd, &PaintStruct);
        hdc = PaintStruct.hdc;
    } else {
        hdc = (HDC)wParam;
    }

    RECT brect = getClientRect();
    FillRect( hdc, &brect, (HBRUSH)GetStockObject( LTGRAY_BRUSH ) );
    swap( &brect );
    brect.left = brect.left + _pos - _thickness / 2;
    brect.right = brect.left + _thickness;
    swap( &brect );
    if ( _immobile ) {
        FillRect( hdc, &brect, (HBRUSH)GetStockObject( LTGRAY_BRUSH ) );
    } else {
        DrawFrameControl( hdc, &brect, DFC_BUTTON, DFCS_BUTTONPUSH |
                (_dragging ? DFCS_PUSHED : 0 ));

    }

    if ( !printClient ) {
	    EndPaint(hwnd, &PaintStruct);
    }
}

void 
SplitterWindow::onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags)
{
    if ( _over ) {
        onMouseMove( hwnd, x, y, keyFlags );

        _dragging = false;
        RECT brect = barRect();
        InvalidateRect( hwnd, &brect, FALSE );
        ReleaseCapture();
    }
}

void
SplitterWindow::onMouseMove(HWND hwnd, int x, int y, UINT keyFlags)
{
    RECT brect = barRect();

    if ( !_immobile && PointInRect( &brect, x, y ) ) {
        SetCursor( LoadCursor( NULL, _horizontal ? IDC_SIZENS : IDC_SIZEWE ) );
        _over = true;
    } else if ( !_dragging ) {
        _over = false;
    }

    if ( _dragging ) {
        RECT srect = getClientRect();
        int distance = _horizontal ? y - _dragStart.y : x - _dragStart.x;
        swap( &srect );
        _pos = _posStart + distance;
        if ( _pos > srect.right - _thickness/2 ) {
            _pos = srect.right - _thickness/2;
        } else if ( _pos < _thickness/2 ) {
            _pos = _thickness/2;
        }
        move();
        InvalidateRect( hwnd, NULL, FALSE );
    }
}

void
SplitterWindow::move()
{
    //int i;
    RECT nrect = getClientRect();
    swap(&nrect);
    /*
    for ( i = 1; i >= 0; i-- ) {
        SplitInfo info = _info[i];
        int width;
        if ( i == 0 ) {
            width = pos - thickness/2;
        } else {
            width = nrect.right - nrect.left - thickness / 2;
        }
        if ( horizontal ) {
            int temp = info.minWidth;
            info.minWidth = info.minHeight;
            info.minHeight = temp;
            temp = info.maxWidth;
            info.maxWidth = info.maxHeight;
            info.maxHeight = temp;
        }

        if ( i == 1 ) {
            if ( info.minWidth > -1 && width < info.minWidth ) {
                pos = (int)(nrect.right - info.minWidth - nrect.left);
            }
            if ( info.maxWidth > -1 && width > info.maxWidth ) {
                pos = (int)(nrect.right - info.maxWidth - nrect.left);
            }
        } else {
            if ( info.minWidth > -1 && width < info.minWidth ) {
                pos = info.minWidth;
            }
            if ( info.maxWidth > -1 && width > info.maxWidth ) {
                pos = info.maxWidth;
            }
        }
    }
    */
    RECT cRect = getClientRect();
    RECT fRect = cRect;
    RECT sRect = fRect;
    swap( &fRect );
    swap( &sRect );

    fRect.right = fRect.left + _pos - _thickness/2;
    sRect.left = sRect.left + _pos + _thickness/2;
    _paneSize[0] = _pos;
    _paneSize[1] = cRect.right - _pos;

    swap( &fRect );
    swap( &sRect );

    if ( _panes[0] ) {
        MoveWindow( _panes[0], 
                fRect.left, fRect.top,
                fRect.right - fRect.left, fRect.bottom - fRect.top,
                TRUE );
    }

    if ( _panes[1] ) {
        MoveWindow( _panes[1], 
                sRect.left, sRect.top,
                sRect.right - sRect.left, sRect.bottom - sRect.top,
                TRUE );
    }
}

void 
SplitterWindow::onSize(HWND hwnd, UINT state, int cx, int cy)
{
    format();
    invalidate();
}
