#ifndef SPLITTERWINDOW_H
#define SPLITTERWINDOW_H

#include "BaseWnd.h"

class SplitterWindow : public Window
{
public:
    SplitterWindow(HINSTANCE);
    virtual ~SplitterWindow();

    void create(HWND hParent);
    void split( HWND pane1, HWND pane2, bool vertical );
    void setSashPosition( int pos, double gravity );
    void setPaneSizes( int pane1, int pane2, double gravity );

protected:
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onPaint(HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
    void swap( RECT* rect );
    void swap( POINT* point );
    RECT barRect();
    void format();
    void move();

    unsigned _numPanes;
    HWND _panes[2];
    bool _horizontal;
    bool _immobile;
    int _pos;
    int _thickness;
    double _gravity;
    bool _over;
    POINT _size;
    POINT _dragStart;
    bool _dragging;
    int _posStart;
    bool _first;
    POINT _originalSize;
    int _paneSize[2];
};

#endif // SPLITTERWINDOW_H
