#ifndef STRINGLIST_H
#define STRINGLIST_H

#include "tchar.h"
#include "List.h"

/**
 * The StringList is a way of storing null terminated strings in a list. When
 * the list is deleted, its contents will be deleted as well.
 */
class StringList
{
public:
    StringList();
    ~StringList();

    void addTail( const TCHAR* item );
    void clear();
    const TCHAR* first() const;
    const TCHAR* next() const;
    void remove();
    bool empty();

    bool operator==( const StringList& other );
    StringList& operator=( const StringList& other );

private:
    List<TCHAR*> _list;
};


#endif // STRINGLIST_H

