#ifndef TEXT_CONTROL_H
#define TEXT_CONTROL_H

#include "BaseWnd.h"
#include "FadingControl.h"

/**
 * @ingroup SlidingControl
 * The TextControl is a sliding control that can contain some word-wrapped
 * text.
 */
class TextControl : public FadingControl
{
public:
    TextControl(HWND hwnd);
    ~TextControl();

    void setText( const TCHAR* text );
    void setFont( const Font& font );
    void setShadow( bool on );
    virtual void draw( HDC hdc );
    virtual void drawFaded( HDC hdc );
    void setColour( COLORREF colour );
    virtual void move( int x, int y, int cx, int cy );
    Font* getFont();
    void setWrap( bool on );
    int moveFormat( int x, int y, int width ); // returns height
    SIZE calcSize( int width = 0 );
    
    enum HAlign_e {
        HAlign_Centre,
        HAlign_Left
    };

    void setHorizontalAlignment( HAlign_e );

private:
    void format();
    POINT _pos;
    TCHAR* _text;
    Font* _font;
    bool _shadow;
    COLORREF _colour;
    HAlign_e _halign;
    bool _wrap;
};

#endif TEXT_CONTROL_H
