#pragma warning(disable:4786)
#include <windows.h>
#include "Timer.h"	

Timer::TimerMap Timer::_timerMap;

VOID CALLBACK Timer::TimerManagerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
	TimerEvent* event = Timer::_timerMap[idEvent];

	if ( event ) {
		event->fire( idEvent );
	}
}

unsigned Timer::RegisterEvent(TimerEvent* event, unsigned int milliseconds)
{
	DWORD id = SetTimer(NULL, NULL, milliseconds, TimerManagerProc);
	_timerMap[id] = event;
    return id;
}

void Timer::CancelEvent(unsigned id)
{
	bool found = false;

    KillTimer( NULL, id );
    _timerMap.erase( id );
}
