#ifndef UTILS_TIMER_H
#define UTILS_TIMER_H

#include <map>

class DrawTimer;

class TimerEvent
{
protected:
    friend class Timer;
    friend class DrawTimer;
	virtual void fire(unsigned id)=0;
};

class Timer
{
public:
	static unsigned RegisterEvent(TimerEvent* event, unsigned milliseconds);
	static void CancelEvent(unsigned);

private:
	typedef std::map<unsigned long, TimerEvent* > TimerMap;

	static TimerMap _timerMap;
	static VOID CALLBACK TimerManagerProc(HWND hwnd, UINT uMsg, UINT idEvent, DWORD dwTime);
};

#endif
