#ifndef TRACE_H
#define TRACE_H

#include <tstring>
#include <set>

class Mutex;

class TraceOutput
{
 public:
  virtual ~TraceOutput(){};
  virtual void sendString(const std::_tstring& str)=0;
};

class TraceLabel;

class Trace
{
public:
	Trace();
	~Trace();

	void setOutput(TraceOutput* output);

	virtual void nextline(bool mutexlock = true);
	virtual void nextline(const std::_tstring& label);

	void setLength(int lines);
	void enable_all();
	void enable(const std::_tstring& group);
	void disable_all();
	
	virtual Trace& operator<<(const std::_tstring& text);
	virtual Trace& operator<<(const _TCHAR* text);
	virtual Trace& operator<<(int value);
	virtual Trace& operator<<(unsigned long value);
	virtual Trace& operator<< ( void (*manip)(Trace&) );
	virtual Trace& operator<< (void* ptr);

	void flush();
protected:
	void construct();
	std::_tstring _current;
	int _backtrace;
	bool _enabled;
	TraceOutput* _output;
	Mutex* _mutex;
	std::set<std::_tstring> _enabledGroups;
};

void endl(Trace& object);

extern Trace trace;

class TraceLabel {
 public:
  TraceLabel(const std::_tstring& test = _T(""));
  ~TraceLabel();
  void label( const std::_tstring& text );

  TraceLabel& operator<<(const std::_tstring& text);
  TraceLabel& operator<<(const _TCHAR* text);
  TraceLabel& operator<<(int value);
  TraceLabel& operator<<(unsigned long value);
  TraceLabel& operator<< ( void (*manip)(Trace&) );
  TraceLabel& operator<< (void* ptr);

 private:
  std::_tstring _label;
  TraceLabel* _debug;
  void assertValid();
};


#endif // TRACE_H
