#include "WideChar.h"
#include <new>
#include <windows.h>
#include <string.h>
#include <assert.h>
#include "debug.h"

WideChar::WideChar( const char* text )
{
    size_t size = strlen( text );
    int newSize;
    _text = new wchar_t[size + 1];
    newSize = MultiByteToWideChar( GetACP(), MB_PRECOMPOSED,
            text, size, _text, size );
    if ( newSize == 0 ) {
        if ( GetLastError() == ERROR_INSUFFICIENT_BUFFER ) {
            delete[] _text;
            int newSize = MultiByteToWideChar( GetACP(), 
                    MB_PRECOMPOSED, text, size, _text,
                    0 );
            _text = new wchar_t[newSize + 1];
            newSize = MultiByteToWideChar( GetACP(), MB_PRECOMPOSED,
                    text, size, _text, newSize );
        } else {
            assert(0);
            throw std::bad_alloc();
        }
    }

    _text[ newSize ] = 0;
}

WideChar::WideChar( const wchar_t* text )
{
    _text = _wcsdup( text );
}

WideChar::~WideChar()
{
    delete[] _text;
}

WideChar::operator const wchar_t*() const
{
    return _text;
}

NarrowChar::NarrowChar( const wchar_t* text )
{
    size_t size = wcslen( text );
    int newSize;
    _text = new char[size + 1];
    newSize = WideCharToMultiByte( GetACP(), 0,
            text, size, _text, size, NULL, NULL );
    if ( newSize == 0 ) {
        if ( GetLastError() == ERROR_INSUFFICIENT_BUFFER ) {
            delete[] _text;
            int newSize = WideCharToMultiByte( GetACP(), 
                    0, text, size, _text,
                    0, NULL, NULL );
            _text = new char[newSize + 1];
            newSize = WideCharToMultiByte( GetACP(), 0,
                    text, size, _text, newSize, NULL, NULL );
        } else {
            assert(0);
            throw std::bad_alloc();
        }
    }

    _text[ newSize ] = 0;
}

NarrowChar::NarrowChar( const char* text )
{
    _text = _strdup( text );
}

NarrowChar::~NarrowChar()
{
    delete[] _text;
}

NarrowChar::operator const char*() const
{
    return _text;
}
