#ifndef XmlApplication_h
#define XmlApplication_h

#include <tstring>
#include <list>
#include <map>
#include "ButtonBar.h"

class XmlAppFactory
{
public:
    XmlAppFactory();
    virtual ~XmlAppFactory();

    virtual WindowFunctions* createWindow( HINSTANCE hInstance, HWND hParent, const _TCHAR* type );
};

class XmlAppListener {
public:
    virtual ~XmlAppListener();
    virtual void onXmlAppEvent( const std::string& event )=0; 
};

class CTag;
class XmlApplication
{
public:
    XmlApplication(HINSTANCE hInstance, XmlAppListener* listener, XmlAppFactory* factory);
    ~XmlApplication();
    bool loadFromString( const std::_tstring& text );
    bool loadFromFile( const std::_tstring& filename );

    void onCommandId( unsigned id );
    void sendEvent( const std::_tstring& event );
private:    
    void parseTag( CTag* tag );
    void parseChildren( CTag* tag );
    void parseFrameWindow( CTag* tag );
    bool parseSize( const _TCHAR* str, int* width, int* height );
    bool parseColour( const _TCHAR* name, unsigned* colour );
    Menu* parseMenu( CTag* menu, bool popup );
    ButtonBar* parseButtonBar( HWND hParent, CTag* tag );
    WindowFunctions* parseWindow( HWND hParent, CTag* tag );
    WindowFunctions* parseSplitter( HWND hParent, CTag* tag );
    WindowFunctions* parsePane( HWND hParent, CTag* tag );
    void error( CTag* tag, const _TCHAR* msg );
    unsigned mapId( const std::_tstring& event );
    HINSTANCE _hInstance;
    XmlAppFactory* _factory;
    XmlAppListener* _listener;
    typedef std::list<WindowFunctions*> WindowList;
    WindowList _windows;
    std::list<Menu*> _menus;
    typedef std::map<int,std::_tstring> IntStringMap;
    IntStringMap _eventIdMap;
    unsigned _nextId;
    bool _delFactory;
};

#endif // XmlApplication_h
