/**
 * @mainpage Steve's util library
 *
 * This is my class library which I use to develop windows applications. I have
 * been developing it since 1999, when I made Banshee Screamer Alarm. It's a
 * mish-mash of things that I have found that all of my applications needed in
 * some way. Being a lazy programmer means never having to write code more than
 * once, so these portions naturally make their way into my util library.

   I currently use the Microsoft Visual Studio 2005 express edition compiler.
   Using custom make files and the gnu make program, I compile all of the utils
   files together with my main program. That way I can take advantage of
   whole-program optimization to make things as small and efficient as
   possible.

   The goal of the framework is to form a lightweight wrapper around Windows
   classes, to make them object oriented. It is not to make them portable to
   other platforms. Abstracting a Font object into a simple class, for example,
   reduces the number of times you need to refer to MSDN documentation to get a
   job done.

   \subsection Compatibility
   The library is designed to produce programs that will run on Windows 95.
   Of course, this level of compatibility is no longer necessary. However, it
   is easy to keep the support in simply by loading a few calls dynamically.
   For example, see SafeGetLongPathName(), SafeGradientFill(), and
   SafeAlphaBlend() for examples.

   In this library you will find several distinct categories of classes:

   \section BaseWnd
   The BaseWnd classes can stand on their own. They form the simplest possible
   object oriented wrapper for Windows. You could get away with including
   nothing else in your program except for BaseWnd.h and BaseWnd.cpp, and you
   would have an object-oriented framework in a single file. These files are
   the natural evolution to the technique that I described in the August 2000
   issue of C/C++ User's Journal: http://www.ddj.com/cpp/184401271. 
   
   Here, you will find the Window class, which is the heart of the framework,
   as well as convienient classes such as Pen, DeviceContext, and Font. There
   is everything you need to build a win32 application using C++.

   \section Sliding Control Library
   The sliding control library allows you to create slick animations with very
   little work. The ButtonControl and TextControl classes can be arranged onto
   a ControlPage, and animated on and offscreen. They do not consume many
   resources because the controls are drawn onto an existing window, rather
   than creating a new window for each control.

   See PhotoWipe (http://www.hanovsolutions.com/?prod=PhotoWipe) for a
   demonstration of the sliding buttons.

   \section Graphics
   The graphics library includes a DibImage and Bitmap classes, as well as a
   way to load and save PNG and JPEG files.

   \section Stream
   The Stream classes provide an abstract input/output stream, without the
   complexity of the c++ std::ostream class. There is also a generic Record
   class that allows you to store a sequence of key/value pairs in a stream.

   \section UndoRedo
   The UndoStack object provides an undo/redo framework, so you can add
   multiple levels of undo/redo to your application.
 */
