// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#include "Dispatcher.h"
#include "dbg.h" // must be last

Dispatcher* _dispatcher;

EventListener::EventListener()
{

}

EventListener::~EventListener()
{
    _dispatcher->unregister(this);
}


Dispatcher::Dispatcher()
{
    _dispatcher = this;
}

Dispatcher::~Dispatcher()
{

}

/**
 * Send an event. All interested classes will be notified by calling onEvent().
 *
 * \warning Classes should not call unregister() while in the event handler.
 * Please not that the destructor of any EventListener class will automatically
 * call unregister().
 */
void
Dispatcher::dispatch(unsigned event)
{
    EventList::iterator iter = _events.begin();
    while( iter != _events.end() ) {
        if ( (*iter).event == event ) {
            iter->listener->onEvent( event );
            // look out for recursion bugs
        }
        ++iter;
    }
}

void
Dispatcher::unregister(EventListener* listener)
{
    EventList::iterator iter = _events.begin();
    while( iter != _events.end() ) {
        if ( (*iter).listener == listener ) {
			EventList::iterator next = iter;
            next++;
            _events.erase(iter);
			iter = next;
		} else {
            ++iter;
		}
    }
}

void
Dispatcher::registerEvent( EventListener* listener, unsigned event )
{
    Event evt;
    evt.event = event;
    evt.listener = listener;
    _events.push_back( evt );
}
