// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef MainViewWindow_H
#define MainViewWindow_H

#include "BaseWnd.h"
#include "SplitWindow.h"
#include "WaveViewWindow.h"
#include "WaveletDoc.h"
#include "ScalogramViewWindow.h"
#include "ButtonBar.h"
#include "Cards.h"
#include "Events.h"

class MainWindow;

/**
 * This window occupies the entire client area of the main window.
 * It contains the toolbar, help area, the scalogram view, and the waveform
 * view.
 */
class MainViewWindow : public SplitWindow, public CardEventListener, public
                       EventListener
{
public:
    MainViewWindow(HINSTANCE);
    ~MainViewWindow();

    void create(HWND hParent, MainWindow* main);
    bool open( const _TCHAR* filename );
    void onViewScalogram();
    void onViewInverse();
    virtual void onCardEvent( const std::string& event );
    virtual void onEvent( unsigned event );
    void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    bool hasDoc();

    ScalogramViewWindow _waveletView;

private:
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void resample(unsigned);
    void continueOpen();

    //void onClose(HWND);
    //void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct);
    //void onDestroy(HWND hwnd);
    //void onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
    //void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    //void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    //void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    //void onPaint(HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient);
    //void onSize(HWND hwnd, UINT state, int cx, int cy);
    HWND _hParent;

    WaveViewWindow _waveView;
    WaveletDocRef _doc;
    ButtonBar _toolbar;
    CardWindow _cards;
    MainWindow* _main;
    WaveformRef _waveform;
};

#endif // MainViewWindow_H
