// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef MainWindow_H
#define MainWindow_H

#include "BaseWnd.h"
#include "MainViewWindow.h"
#include "Events.h"
class WaveletDoc;

/**
 * The MainWindow is main window of the program. It doesn't too much.
 * It just creates the MainViewWindow and sets its size to fill the client
 * area. The real work is done in that class.
 */
class MainWindow : public Window, public EventListener
{
public:
    MainWindow(HINSTANCE);
    ~MainWindow();

    void create();
    virtual void onEvent( unsigned event );

private:
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void onClose(HWND);
    void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct);
    void onPaint(HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
    void onOpen();
    int onInitMenuPopup(HWND hwnd, HMENU hMenu, UINT item, BOOL fSystemMenu);

    Menu _mainMenu;
    Menu _editMenu;
    Menu _fileMenu;
    Menu _viewMenu;
    Menu _helpMenu;

    MainViewWindow _mainView;
};

#endif // MainWindow_H
