// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef PlayTask_H
#define PlayTask_H

#include "Task.h"
#include "SoundImage.h"

class DibImage;

/**
  * Parameters for PlayTask.
  */
class PlayTaskParams 
{
public:
    /// SoundImage to play
    SoundImage* image;

    /// Which row to start playing.
    unsigned rowStart;

    /// Number of rows to play.
    unsigned numRows;

    /// Which column to start playing.
    unsigned offset;

    /// Number of columns to play.
    unsigned length;
};

/**
  * The PlayTask will first reconstruct the sound from a rectangular region of
  * the wavelet transform, and then play it.
  *
  * \warning Make sure nothing else is playing before calling this, otherwise
  * there will be an instant crash.
  */
class PlayTask : public Task<PlayTaskParams>
{
public:
	PlayTask( TaskObserver* observer );
	virtual ~PlayTask();

private:	
    virtual void run( PlayTaskParams params );
};

#endif // PlayTask_H
