// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#include "PlayWaveformTask.h"
#include "SoundDevice.h"
#include "Waveform.h"
#include <math.h>
#include "dbg.h" // must be last

PlayWaveformTask::PlayWaveformTask( TaskObserver* observer ) :
    Task<PlayWaveformTaskParams>::Task( observer )
{

}

PlayWaveformTask::~PlayWaveformTask()
{

}

void
PlayWaveformTask::run( PlayWaveformTaskParams params )
{
    // increase thread priority for audio pump.
    elevatePriority();

    // Play the produced waveform.
    SoundDevice::Initialize( params.wave->sampleRate, 1 );
    SoundDevice* dev = SoundDevice::instance();

    dev->beginPlay();

    unsigned size = dev->samplesPerBlock();
    unsigned numSamplesPlayed = 0;

    while(!_stopRequested && numSamplesPlayed != params.wave->size ) {
        short* buffer = (short*)dev->allocateBlock();
        unsigned i = 0;

        for ( i = 0; i < (unsigned)size && numSamplesPlayed < params.wave->size; i++, numSamplesPlayed++ ) {
            buffer[i] = (short)(params.wave->samples[numSamplesPlayed] * 32767); 
        }

        for ( ; i < size; i++ ) {
            buffer[i] = 0;
        }

        dev->write( (unsigned char*)buffer );
    }

    dev->endPlay();

    SoundDevice::shutdown();
}
