// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#include "Task.h"
#include "dbg.h" // must be last

TaskObserver::~TaskObserver()
{
}

AbstractTask::AbstractTask( TaskObserver* observer ) :
    _observer(observer),
    _progress(0.0),
    _done( false )
{

}

AbstractTask::~AbstractTask()
{
    stop();
}

double
AbstractTask::getProgress()
{
    return _progress;
}

bool
AbstractTask::done()
{
    return _done;
}

void 
AbstractTask::stop()
{
    _stopRequested = true;
    onStop();
    join();
}

void
AbstractTask::onStop()
{
}

/**
  * Report progress information to the Task's observer. 
  *
  * \param progress Number in the range of 0.0 to 1.0 to represent the
  * completion of the task.
  */
void
AbstractTask::setProgress( double progress ) 
{
    _progress = progress;
    _observer->onTaskNotify(this);
}

/**
  * Notifies that we are done. This should not be called from the run() method.
  * It is automatically called by the template.
  */ 
void
AbstractTask::setDone()
{
    _done = true;
    _observer->onTaskNotify(this);
}

