#include <assert.h>
#include <windowsx.h>
#include "ViewWindow.h"
#include "dbg.h" // must be last

ViewWindow::ViewWindow(HINSTANCE hInstance)
{
	_hInstance = hInstance;
	_pszClassName = TEXT("ViewWindow");
	_pszTitle = TEXT("View Window");

    _dwStyle |= WS_CHILD | WS_VISIBLE; 
 
    _WndClass.hbrBackground = (HBRUSH)NULL_BRUSH;
    _WndClass.hCursor = NULL;
	//_WndClass.style |= CS_HREDRAW | CS_VREDRAW;
    _dwExtendedStyle |= 0;
}


ViewWindow::~ViewWindow()
{

}

void
ViewWindow::create(HWND hParent)
{
    _hParent = hParent;

    if ( NULL == Window::Create( CW_USEDEFAULT, CW_USEDEFAULT, 
                CW_USEDEFAULT, CW_USEDEFAULT, _hParent, 0, _hInstance ) ) {
        DWORD dwErr = GetLastError();
        assert( false );
    }
}

LRESULT 
ViewWindow::WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed)
{
    *pbProcessed = TRUE;

    switch(msg)
    {
        HANDLE_MSG(hwnd, WM_CLOSE, onClose);
        HANDLE_MSG(hwnd, WM_COMMAND, onCommand);
        HANDLE_MSG(hwnd, WM_CREATE, onCreate);
        HANDLE_MSG(hwnd, WM_DESTROY, onDestroy);          
        HANDLE_MSG(hwnd, WM_KEYDOWN, onKey);
        HANDLE_MSG(hwnd, WM_LBUTTONDOWN, onLButtonDown);
        HANDLE_MSG(hwnd, WM_LBUTTONUP, onLButtonUp);
        HANDLE_MSG(hwnd, WM_MOUSEMOVE, onMouseMove);
        HANDLE_MSG(hwnd, WM_SIZE, onSize);
        case WM_ERASEBKGND:
            return 1;
        case WM_PRINTCLIENT:
            onPaint(hwnd, wParam, lParam, true);  
            return 0;
        case WM_PAINT:
            onPaint(hwnd, wParam, lParam, false);
            return 0;
    }
    
    *pbProcessed = FALSE;
    return 0;
}


void
ViewWindow::onClose(HWND)
{

}

void 
ViewWindow::onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{

}

BOOL 
ViewWindow::onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct)
{

    return TRUE;
}

void
ViewWindow::onDestroy(HWND hwnd)
{

}


void 
ViewWindow::onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags)
{


}

void 
ViewWindow::onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, 
                               UINT keyFlags)
{

}

void 
ViewWindow::onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags)
{

}

void
ViewWindow::onMouseMove(HWND hwnd, int x, int y, UINT keyFlags)
{

}


void 
ViewWindow::onPaint( HWND hwnd, WPARAM wParam, LPARAM lParam, 
        bool printClient )
{
	PAINTSTRUCT PaintStruct;
    HDC hdc;

    if ( !printClient ) {
	    BeginPaint(hwnd, &PaintStruct);
        hdc = PaintStruct.hdc;
    } else {
        hdc = (HDC)wParam;
    }

    Brush brush(RGB(0,0,0));
    RECT rect = getClientRect();
    FillRect( hdc, &rect, brush );
    TextOut( hdc, 0, 0, "Hello!", 6);

    if ( !printClient ) {
	    EndPaint(hwnd, &PaintStruct);
    }
}


void 
ViewWindow::onSize(HWND hwnd, UINT state, int cx, int cy)
{

}

void 
ViewWindow::setDoc( WaveletDocRef doc )
{
    _doc = doc;
    InvalidateRect( hwnd, NULL, FALSE );
}

