#ifndef ViewWindow_H
#define ViewWindow_H

#include "BaseWnd.h"
#include "WaveletDoc.h"

/**
 * Base class from which views of the waveform can be derived.
 * Doesn't really do anything. Should be removed.
 */
class ViewWindow : public Window
{
public:
    ViewWindow(HINSTANCE);
    ~ViewWindow();

    void create(HWND hParent);
    virtual void setDoc( WaveletDocRef doc );

protected:
    WaveletDocRef _doc;

private:
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void onClose(HWND);
    void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct);
    void onDestroy(HWND hwnd);
    void onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onPaint(HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
    HWND _hParent;
};

#endif // ViewWindow_H
