// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#ifndef WaveViewWindow_H
#define WaveViewWindow_H

#include "BaseWnd.h"
#include "ViewWindow.h"
#include "Waveform.h"

class ScalogramViewWindow;

/**
 * Draws a Waveform to the screen. Allows the user to select a particular
 * region of the waveform to view.
 */
class WaveViewWindow : public ViewWindow, public WaveformObserver
{
public:
    WaveViewWindow(HINSTANCE);
    ~WaveViewWindow();

    void create(HWND hParent);

    void setScalogramView( ScalogramViewWindow* );
    virtual void setDoc( WaveletDocRef doc );
    unsigned getSelStart();
    unsigned getSelEnd();

    void clearSel();

    virtual void onWaveformChanged( Waveform* );

private:
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void onClose(HWND);
    void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct);
    void onDestroy(HWND hwnd);
    void onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onPaint(HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
    void getSelExtentsPixels( int* start, int* end );
    HWND _hParent;

    int _selStart; /// Selected region, in samples.
    int _selEnd; /// one past end of selection.

    POINT _dragStart;
    bool _dragging; /// True if user is resizing the selection.

    /// True if user is moving the selection without changing its size..
    bool _moving;

    ScalogramViewWindow* _scalogramView;
};

#endif // WaveViewWindow_H
