// -----------------------------------------------------------------------------
// Copyright 2008 Steve Hanov. All rights reserved.
//
// For permission to use, please contact steve.hanov@gmail.com. Permission will
// usually be granted without charge.
// -----------------------------------------------------------------------------
#include "WaveletApplication.h"
#include <commctrl.h>
#include <string>
#include <string.h>
#include <stdlib.h>
#include <shlobj.h>
#include "MainWindow.h"
#include "WaveletOptions.h"
#include "dbg.h" // must be last

WaveletApplication* _application = 0;
#define WEBPAGE_URL "http://gandolf.homelinux.org/~smhanov/wavelet"

WaveletApplication::WaveletApplication( HINSTANCE hInstance ) : 
    BaseApplication( hInstance, "Wavelet Sound Explorer", (float)0.50 )
{
    _application = this;
    _mainWindow = NULL;
}

WaveletApplication::~WaveletApplication()
{

}

#define stricmp _stricmp

static unsigned
StripFilenameFromPath( TCHAR* buffer )
{
    TCHAR* slash = _tcsrchr( buffer, _T('\\') );
    if ( slash ) {
        slash[1] = 0;
        return slash - buffer + 1;
    } else {
        buffer[0] = 0;
        return 0;
    }
}

static unsigned
GetModulePath( TCHAR* buffer, unsigned size )
{
    unsigned totalLen;

    totalLen = GetModuleFileName( GetModuleHandle(NULL), buffer, size );
    buffer[totalLen] = 0;
    if ( totalLen == 0 ) {
        return 0;
    }

    return StripFilenameFromPath( buffer );
}

static void DebugPrinter( const char* str )
{
    printf("%s", str);
}

bool 
WaveletApplication::initialize( const TCHAR* lpszCommandLine )
{
    const static int keys[] = { DMEMLEAK, DTHREAD, DDISK, 0 };
    dbgSetHandler( DebugPrinter );
    dbgSetKeys( keys );
    TCHAR buffer[MAX_PATH*2];
    GetModulePath(buffer, sizeof(buffer));
    SetCurrentDirectory(buffer);
    
    _dispatcher = new Dispatcher();
    _options = new WaveletOptions();
    std::string open;
    CommandLine cmd(lpszCommandLine);
    for( unsigned i = 0; i < cmd.size(); i++ ) {
        const char* tok = cmd.get(i);
        if ( 0 == stricmp(tok, "/install" ) ) {
            install(true);
            return false;
        } else if (0 == stricmp( tok, "/uninstall" ) ) {
            install(false);
            return false;
        } else {
            open = tok;
        }
    }

    AttachToConsole();

    InitCommonControls();

    _mainWindow = new MainWindow( getInstance() );
    _mainWindow->create();

    return true;
}

void
WaveletApplication::uninitialize()
{
    delete _mainWindow;
    delete _options;
    delete _dispatcher;
}

void 
WaveletApplication::openWebPage()
{
    ShellExecute(_mainWindow->hwnd, "open", WEBPAGE_URL, NULL, NULL, SW_SHOWNORMAL);
}

void 
WaveletApplication::quit()
{
    delete _mainWindow;
}


void 
WaveletApplication::install( bool bInstall )
{
    //associateFiles(bInstall);
}
    
int WINAPI WinMain(HINSTANCE hInst, HINSTANCE,
                   LPSTR lpszCmdLine, int )
{
    dbgInitOutput();
    InitBaseWnd( hInst, 0.75 );
    WaveletApplication app(hInst);

    return app.run(lpszCmdLine);
}
