#ifndef DATE_H
#define DATE_H


/**
 * The Date class permits addition and substraction of dates, and calculation
 * of the day of the week.  Please note that addition and subtraction is done
 * in a loop, and may be slow depending on the number of days added or
 * subtracted.
 */
class Date
{
public:
	enum Month_e {
		January = 1,
		February,
		March,
		April,
		May,
		June,
		July,
		August,
		September,
		October,
		November,
		December
	};

	Date( unsigned int year, Month_e month, unsigned int day );
	virtual ~Date();

	Date( const Date& other );
	Date& operator=( const Date& other );

    // returns difference in days
    int operator-( const Date& other );
    Date operator+(int days );
    Date operator-( int days );
    Date& operator+=( int days );
    Date& operator-=( int days );
	static Date current();

	enum Day_e {
		Sunday,
		Monday,
		Tuesday,
		Wednesday,
		Thursday,
		Friday,
		Saturday
	};

	static unsigned int daysInMonth( Month_e the_month, unsigned int year );
	unsigned int daysInMonth( );
	unsigned int daysInMonth( Month_e the_month );
	static bool isLeapYear( unsigned int year );
    static int numMonths();
	bool isLeapYear();
    unsigned int daysSinceEpoch() const; // January 1, 1 A.D.
    static Month_e nextMonth( Month_e month );

	static const char* monthString( Month_e month );
	const char* monthString();
	static const char* monthStringAbb( Month_e month );
	static const char* dayOfWeekString( Day_e day );
    const char* dayOfWeekString();
	unsigned int dayOfMonth() const;
	static Day_e dayOfWeek( int year, int month, int day );
	Day_e dayOfWeek();
	Month_e month() const;
	unsigned int year() const;
    unsigned int dayOfYear();

	void increment();
	void decrement();

	bool operator==( const Date& right );
	bool operator<( const Date& right );
	bool operator<=( const Date& right );
	bool operator>( const Date& right );
	bool operator>=( const Date& right );

	bool format( char* buffer, int* bufferlen );

private:
	unsigned int _year;
	Month_e _month;
	unsigned int _dayOfMonth;
};

Date::Month_e operator++( Date::Month_e& month );

#endif /* DATE_H */
