#pragma warning(disable:4786)
#include "FadingControl.h"
#include "DrawTimer.h"
#include <assert.h>

class FadeTimer : public TimerEvent
{
public:
    FadeTimer( FadingControl* parent) {
        _parent = parent;
        id = 0;
        _set = false;
    }

    unsigned id;
    bool _set;
    FadingControl* _parent;

    void set(unsigned ms) {
        if ( _set ) {
            DrawTimer::CancelEvent( this );
        }

        id = DrawTimer::RegisterEvent( this );
        _set = true;
    }

    void stop() {
        assert( _set );
        if ( _set ) {
            DrawTimer::CancelEvent( this );
        }
        _set = false;
    }

    ~FadeTimer() {
        DrawTimer::CancelEvent( this ); 
        _parent = 0;
    }

    virtual void fire( unsigned id ) {
        _parent->onTimer();
    }
};



FadingControl::FadingControl(HWND hwnd) :
    Control(hwnd)
{
    _allowFading = false;
    _fadeTimeMs = Control::DefaultFadeMs;
    _fadeTimer = new FadeTimer( this );
    _fadeState = Not_Fading;
    _intensity = 1.0;
    _fadedColour = RGB(128,128,128);
}

FadingControl::~FadingControl()
{
    delete _fadeTimer;
}

void
FadingControl::allowFading( bool allow )
{
    _allowFading = allow;
    if ( allow ) {
        _intensity = 0.0;
    } else {
        _intensity = 1.0;
    }
}

void
FadingControl::setFadeTime( unsigned TimeMs )
{
    _fadeTimeMs = TimeMs;
}

void
FadingControl::drawFaded( HDC dc )
{

}

void
FadingControl::onMouseEnter()
{
    Control::onMouseEnter();
    //OutputDebugString(TEXT("OnMouseEnter()"));
    if ( _allowFading && _fadeState == Not_Fading ) {
        _fadeTimer->set( 10 );
        _timeStarted = GetTickCount();
    } else {
        int elapsed = GetTickCount() - _timeStarted;
        _timeStarted = GetTickCount() + elapsed - _fadeTimeMs;
    }
    _fadeState = Fading_In;
}

void
FadingControl::onMouseOut()
{
    Control::onMouseOut();
    //OutputDebugString(TEXT("OnMouseOut()"));
    if ( _allowFading && _fadeState == Not_Fading ) {
        _fadeTimer->set( 10 );
        _timeStarted = GetTickCount();
    } else {
        int elapsed = GetTickCount() - _timeStarted;
        _timeStarted = GetTickCount() + elapsed - _fadeTimeMs;
    }
    _fadeState = Fading_Out;
}

double
FadingControl::intensity()
{
    return _intensity;
}

void
FadingControl::onTimer()
{
    invalidate();
    if ( GetTickCount() - _timeStarted > _fadeTimeMs ) {
        _fadeTimer->stop();
        if ( _fadeState == Fading_In ) {
            _intensity = 1.0;
        } else {
            _intensity = 0.0;
        }
        _fadeState = Not_Fading;
        return;
    }

    _intensity = (double)((unsigned)GetTickCount() - _timeStarted) /
        _fadeTimeMs;

    if ( _fadeState == Fading_Out ) {
        _intensity = 1.0 - _intensity;
    }
}

void
FadingControl::setFadedColour( COLORREF colour )
{
    _fadedColour = colour;
}

COLORREF
FadingControl::getFadeColour( COLORREF colour )
{
    double r,g,b;
    r = (double) GetRValue( _fadedColour ) + 
        ((double)GetRValue( colour) - GetRValue( _fadedColour )) * _intensity;  
    g = (double) GetGValue( _fadedColour ) + 
        ((double)GetGValue( colour) - GetGValue( _fadedColour )) * _intensity;  
    b = (double) GetBValue( _fadedColour ) + 
        ((double)GetBValue( colour) - GetBValue( _fadedColour )) * _intensity;  
//    r = (double)GetRValue(_fadedColour)*(1.0-_intensity) + (double)GetRValue(colour)*_intensity;
//    g = (double)GetGValue(_fadedColour)*(1.0-_intensity) + (double)GetGValue(colour)*_intensity;
//    b = (double)GetBValue(_fadedColour)*(1.0-_intensity) + (double)GetBValue(colour)*_intensity;

    return RGB( (unsigned)r, (unsigned)g, (unsigned)b );
}

