// FileEnumerator.h: interface for the FileEnumerator class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FILEENUMERATOR_H__4CBCB8EB_141F_11D5_84D3_00B0D078FA3E__INCLUDED_)
#define AFX_FILEENUMERATOR_H__4CBCB8EB_141F_11D5_84D3_00B0D078FA3E__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#pragma warning(disable:4786)
#include <windows.h>
#include <tchar.h>
#include <stack>
#include <tstring>

namespace FileSystem {

class Exception {
public: 
	Exception() {}
};

/**
 * Encapsulates a filename, allowing you to extract its extension and determine
 * if it exists and is readonly.
 */
class File 
{
public:
	File(const WIN32_FIND_DATA* pData, const std::_tstring& path);
	File();
	File(const _TCHAR* fullPath);
	virtual ~File();

	File(const File& right);
	const File& operator=(const File& right);
	std::_tstring name();
	std::_tstring path();
	std::_tstring extension();
	bool isReadOnly();
	bool isFolder();
	bool exists();
	void makeReadOnly(bool readOnly);
	void erase();
    FILETIME writeTime();

protected:
	WIN32_FIND_DATA _data;
	bool _good;
	std::_tstring _path;
};

/**
 * Enumerates the files matching the given path. The path may contain
 * wildcards. It does not delve into subdirectories. Use
 * RecursiveFileEnumerator for that.
 */
class FileEnumerator  
{
public:
	FileEnumerator(const _TCHAR* fullPath);
	virtual ~FileEnumerator();

	bool more();
	
	File next();

private:
	HANDLE _handle;
	WIN32_FIND_DATA _data;
	bool _found;
	std::_tstring _path;
};

/**
 * Enumerates the files in the given path, and all subfolders.
 */
class RecursiveFileEnumerator
{
public:
	RecursiveFileEnumerator(const _TCHAR* fullPath);
	virtual ~RecursiveFileEnumerator();

	bool more();
	File next();

private:
	FileEnumerator* getEnum();

	std::stack<FileEnumerator*> _dirStack;
};

};

#endif // !defined(AFX_FILEENUMERATOR_H__4CBCB8EB_141F_11D5_84D3_00B0D078FA3E__INCLUDED_)
