#ifndef FLEXLIST_H
#define FLEXLIST_H

#include "BaseWnd.h"
#include "List.h"

class ListItem;

/**
 * Override this class to obtain notifications when the user does things to the
 * FlexList.
 */ 
class FlexListNotify
{
public:
    FlexListNotify();
    virtual ~FlexListNotify();

protected:
    friend class FlexList;
    virtual void onFlexDoubleClick(int index);
    virtual void onFlexSelChanged(int index);
    virtual void onFlexClicked();
    //virtual void onLaunchListKey(int vkey);
    //virtual void onLaunchListRightClick(int id);
    //virtual void onLaunchListEditItem(int id, const char* text);
};

/**
 * @ingroup Controls
 *
 * The FlexList is designed to replace a windows list box. For thousands of
 * items, the windows list box is too slow. Also, it doesn't allow you to
 * change the colours of the highlighted item. The FlexList is a more efficient
 * replacement.
 *
 * To obtain events, sublcass the FlexListNotify object.
 */ 
class FlexList : public Window
{
public:
    FlexList( HINSTANCE );
    virtual ~FlexList();

    virtual HWND create( int x, int y, int cx, int cy, HWND hParent );
    void add( ListItem* );
    void setNotify(FlexListNotify*);
    void insert( ListItem*, int index );
    int getCount();
    void scrollToBottom();
    void reformat(int index);
    bool isItemVisible( int index );
    void invalidate( int index );
    void invalidate( ListItem* item );
    void clear();
    void setSelected( int index );
    int getSelected( int index ); // -1 for first
    void setFocused( int index );
    int getFocused();
    void setBackColour( COLORREF );
    void ensureVisible( int index );
    int itemFromPoint( int x, int y );

protected:
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    void onClose(HWND);
    void onCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
    BOOL onCreate(HWND hwnd, LPCREATESTRUCT lpCreateStruct);
    void onDestroy(HWND hwnd);
    void onKey(HWND hwnd, UINT vk, BOOL fDown, int cRepeat, UINT flags);
    void onLButtonDown(HWND hwnd, BOOL fDoubleClick, int x, int y, UINT keyFlags);
    void onLButtonUp(HWND hwnd, int x, int y, UINT keyFlags);
    void onMouseMove(HWND hwnd, int x, int y, UINT keyFlags);
    void onSize(HWND hwnd, UINT state, int cx, int cy);
    void onPaint( HWND hwnd, WPARAM wParam, LPARAM lParam, bool printClient );
    void onVScroll( HWND hwnd, HWND hwndCtl, UINT code, int pos );
    void extend();
    void paintItems(HDC);
    void scrollTo( int position );

    FlexListNotify* _notify;
    ListItem** _items;
    int _items_used;

private:
    int _items_alloc;
    int _totalHeight;
    int _curPos;
    int _offset; // Where the top of the current item is above the window.
    int _topItem; // Which item is the first displayed.
    int _height;
    int _width;
    bool _redraw; // WM_SETREDRAW
    int _focused;
    double _averageItemHeight;
    COLORREF _backColour;
};

#endif // FLEXLIST_H
