#include "FlexListView.h"
#include "LineItem.h"

static Font _defaultFont;

FlexListView::FlexListView( HINSTANCE hInstance ) : 
    FlexList( hInstance )
{
    _info.hImageList = 0;
    _info.font = &_defaultFont;
    _info.BackColour = RGB(255,255,255);
    _info.TextColour = RGB(0,0,0);
    _info.SelBackColour = RGB(0,0,128);
    _info.SelTextColour = RGB(255,255,0);
}

FlexListView::~FlexListView()
{
}

/**
 * Set the images that are referred to in FlexListView::add().
 */ 
void
FlexListView::setImageList( HIMAGELIST hImageList ) 
{
    _info.hImageList = hImageList;
}

/**
 * Sets the font for all the items.
 */ 
void
FlexListView::setFont( Font* font )
{
    _info.font = font;
}

/**
 * Sets the colours associated with all the items.
 *
 * @param bc Background colour
 * @param tc Text Colour when not selected
 * @param sbc Selected item background colour.
 * @param stc Selected item foreground colour.
 */ 
void
FlexListView::setColours( COLORREF bc, COLORREF tc, COLORREF sbc, COLORREF stc )
{
    _info.BackColour = bc;
    _info.TextColour = tc;
    _info.SelBackColour = sbc;
    _info.SelTextColour = stc;
    setBackColour( bc );
}

/**
 * Adds a text string and image to the FlexListView.
 *
 * @param icon Index of icon in the image liast passed to setImageList().
 * @param text Text
 * @param data Data associated with the item.
 */ 
void 
FlexListView::add(int icon, const _TCHAR* text, void* data )
{
    LineItem* item = new LineItem(&_info);
    item->setText( text );
    item->setImage( icon );
    item->pdata = data;

    FlexList::add( item );
}

/**
 * Returns the data associated with the item, which was given in add().
 *
 * @param index Index of item.
 */ 
void* FlexListView::getItemData( int index )
{
    if ( index < 0 || index >= _items_used ) {
        return 0;
    }

    LineItem* item = dynamic_cast<LineItem*>(_items[index]);
    if ( !item ) {
        return 0;

    }

    return item->pdata;
}

LRESULT 
FlexListView::WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed)
{
    *pbProcessed = TRUE;

#if 0
    switch(msg)
    {
        default:
            ;
    }

#endif

    *pbProcessed = FALSE;

    return FlexList::WindowProc(hwnd, msg, wParam, lParam,
            pbProcessed );
}

