#ifndef FLEXLISTVIEW_H
#define FLEXLISTVIEW_H

#include "FlexList.h"
#include <commctrl.h>
#include <tchar.h>

class FlexListViewInfo
{
public:
    Font* font;
    HIMAGELIST hImageList;
    COLORREF BackColour;
    COLORREF TextColour;
    COLORREF SelBackColour;
    COLORREF SelTextColour;
};

/**
 * @ingroup Controls
 * The FlexListView object overrides the FlexList object to allow you to add
 * text items, instead of items that you draw yourself.
 *
 * The text items may have an image assocaited with them.
 */
class FlexListView : public FlexList
{
public:
    FlexListView(HINSTANCE);
    virtual ~FlexListView();

    void setFont(Font*);
    void setImageList( HIMAGELIST hImageList );
    void add(int icon, const _TCHAR* text, void* data );
    void setColours( COLORREF, COLORREF, COLORREF, COLORREF );
    void* getItemData( int index );
protected:
	virtual LRESULT WindowProc(HWND hwnd, UINT msg, WPARAM wParam,
		LPARAM lParam, PBOOL pbProcessed);

    HIMAGELIST _hImageList;
    FlexListViewInfo _info;
};

#endif // FLEXLISTVIEW_H
