#ifndef LINEITEM_H
#define LINEITEM_H

#include <windows.h>
#include <commctrl.h>
#include "ListItem.h"

class FlexListViewInfo;

/**
 * @ingroup Controls
 * The LineItem class is used internally by the FlexListView class to display a
 * line of text, and optionally an icon beside it.
 */
class LineItem : public ListItem
{
public:
    LineItem(FlexListViewInfo* info);
    ~LineItem();

    void setText(const TCHAR* text);
    void setImage( int index );
    int width();
    int height();

    int format( int width );
    void draw( HDC dc, int x, int y );

    void* pdata;

private:
    TCHAR* _text;
    int _width;
    int _height;
    FlexListViewInfo* _info;
    bool _formatted;
    int _image;
};


#endif // LINEITEM_H
